import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: '',
    children: [
      {
        path: 'socket',
        loadChildren: () => import('./socket/socket.module').then((m) => m.SocketModule)
      },
      {
        path: '',
        pathMatch: 'full',
        redirectTo: 'socket'
      }
    ]
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
