import { isChannelResponsePacket } from './websocket-message';
import { getClientDownloadUrl } from './agent';
import { ConnectorMessageType } from './connector';
export class Identitydoc {
    socket;
    constructor() { }
    async init(params) {
        const webSocketUrl = params.connectionUrl;
        const apiKey = params.auth.credentials.apiKey;
        const appWebsocketUrl = `${webSocketUrl}?ApiKey=${apiKey}`;
        const agentDomain = params.agentDomain;
        this.socket = new IdentitydocSocket(appWebsocketUrl, agentDomain);
    }
}
export class IdentitydocSocket {
    onMessage;
    webSocketUrl;
    agentDomain;
    webSocket;
    constructor(webSocketUrl, agentDomain = null) {
        this.webSocketUrl = webSocketUrl;
        this.agentDomain = agentDomain;
    }
    close() {
        if (this.webSocket) {
            this.webSocket.close();
            this.webSocket = null;
        }
    }
    async start() {
        return new Promise((resolve, reject) => {
            if (this.webSocket != null) {
                this.close();
            }
            this.webSocket = new WebSocket(this.webSocketUrl);
            this.webSocket.onopen = () => {
                console.log('WebSocket Opened');
                this.initSocketConnections();
                resolve();
            };
            this.webSocket.onerror = (e) => {
                console.log('WebSocket Error: ', e);
                reject(e);
            };
            this.webSocket.onclose = () => {
                console.log('WebSocket Close, restarting');
                this.start();
            };
            this.webSocket.onmessage = (e) => {
                const websocketMessage = JSON.parse(e.data);
                console.log('Websocket Message: ', websocketMessage);
                // Open channel response
                if (isChannelResponsePacket(websocketMessage)) {
                    const channels = websocketMessage.payload;
                    this.startIntent(channels);
                }
                else if (this.onMessage && typeof this.onMessage === 'function') {
                    // FIXME: facciamo passare CHANNEL_RESPONSE alla onMessage?
                    this.onMessage(websocketMessage);
                }
            };
        });
    }
    subscribe(fn) {
        this.onMessage = fn;
    }
    // WebSocket initialization section
    initSocketConnections() {
        this.subscribeToSocket();
    }
    subscribeToSocket() {
        const subscribeMessage = {
            action: 'subscribe'
        };
        this.webSocket.send(JSON.stringify(subscribeMessage));
    }
    // End section
    // Connector section
    startAgent() {
        const createChannelMessage = {
            action: 'channel-request'
        };
        this.webSocket.send(JSON.stringify(createChannelMessage));
    }
    sendCan(can) {
        const readCieMessage = {
            action: 'connector-request',
            payload: {
                message: ConnectorMessageType.CIE_READ_DATA,
                data: JSON.stringify({ CAN: can })
            }
        };
        this.webSocket.send(JSON.stringify(readCieMessage));
    }
    buildIntentUrl(pub, sub) {
        return ('ddna://' +
            this.agentDomain +
            '?proto=https:&pub=' +
            sub.replace(/^http[s]?:\/\//g, '') +
            '&sub=' +
            pub.replace(/^http[s]?:\/\//g, ''));
    }
    startIntent(channels) {
        const intentUrl = this.buildIntentUrl(channels.pub, channels.sub);
        console.debug({ intentUrl });
        const iframe = document.createElement("iframe");
        iframe.style.display = "none";
        iframe.src = intentUrl;
        document.body.appendChild(iframe);
    }
    // End section
    // Agent Download section
    downloadAgent() {
        const a = document.createElement("a");
        a.href = getClientDownloadUrl();
        a.target = "_blank";
        a.click();
    }
}
//# sourceMappingURL=data:application/json;base64,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