import { IdentitydocWebSocketPacket } from './websocket-message';
import { Credentials } from './credentials';
export declare class Identitydoc implements IIdentitydoc {
    socket: IdentitydocSocket;
    constructor();
    init(params: IdentitydocInitParameters): Promise<void>;
}
export declare class IdentitydocSocket implements IIdentitydocSocket {
    private onMessage;
    private readonly webSocketUrl;
    private readonly agentDomain;
    private webSocket;
    constructor(webSocketUrl: string, agentDomain?: string);
    close(): void;
    start(): Promise<void>;
    subscribe(fn: (message: IdentitydocWebSocketPacket) => void): void;
    private initSocketConnections;
    private subscribeToSocket;
    startAgent(): void;
    sendCan(can: string): void;
    private buildIntentUrl;
    private startIntent;
    downloadAgent(): void;
}
export interface IIdentitydoc {
    init: (params: IdentitydocInitParameters) => Promise<void>;
    socket: IIdentitydocSocket;
}
export interface IdentitydocInitParameters {
    auth: Credentials;
    connectionUrl: string;
    agentDomain?: string;
}
export interface IIdentitydocSocket {
    start: () => Promise<void>;
    close: () => void;
    subscribe: (fn: (message: IdentitydocWebSocketPacket) => void) => void;
    sendCan?: (can: string) => void;
    downloadAgent?: () => void;
}
