import { Component, OnInit } from '@angular/core';
import { filter, map, tap } from 'rxjs';

import { IdentityDocService } from "../shared/identity-doc.service";
import { isConnectorClientConnectedMessagePacket, isConnectorErrorPacket, isSubscribeResponsePacket } from "connector_sdk/build/module/lib/websocket-message";

@Component({
  selector: 'app-socket',
  templateUrl: './socket.component.html',
  styleUrls: ['./socket.component.scss']
})
export class SocketComponent implements OnInit{
  can: string | undefined | null;
  canSent = false;

  messages$ = this.identityDocService.socketMessages$;

  subscribed$ = this.messages$.pipe(map((messages) =>
    messages.some((message) => isSubscribeResponsePacket(message))
  ));

  readerConnected$ = this.messages$.pipe(map((messages) =>
    messages.some((message) => isConnectorClientConnectedMessagePacket(message))
  ));

  constructor(protected identityDocService: IdentityDocService) { }

  ngOnInit(): void {
    this.messages$.pipe(
      filter((messages) => messages.some((message) => isConnectorErrorPacket(message))),
      tap(() => this.canSent = false)
    ).subscribe();
  }

  onSendCan() {
    if (this.can) {
      this.identityDocService.sendCan(this.can);
      this.canSent = true;
    }
  }

  onOpenAgent() {
    this.identityDocService.startAgent();
  }

  onDownloadAgent() {
    this.identityDocService.downloadAgent();
  }
}
