import { Injectable } from '@angular/core';
import { BehaviorSubject } from "rxjs";

import {environment} from "../../environments/environment";

import { Identitydoc } from 'connector_sdk/build/module/lib/identitydoc';

@Injectable({
  providedIn: 'root'
})
export class IdentityDocService {
  identitydoc = new Identitydoc();

  private _socketMessages$ = new BehaviorSubject<any[]>([]);
  readonly socketMessages$ = this._socketMessages$.asObservable();
  get socketMessages(): any { return this._socketMessages$.getValue(); }

  constructor() {
    this.identitydoc.init(environment.identitydoc)
      .then(() => {
        this.startSocket();
      });
  }

  public async startSocket(): Promise<void> {
    await this.identitydoc.socket.start();
    this.identitydoc.socket.subscribe((message: any) => {
      console.log('SOCKET MESSAGE:', message);
      this._socketMessages$.next([...this.socketMessages, message]);
    });
  }

  public sendCan(can: string): void {
    if (can) {
      this.identitydoc.socket.sendCan(can);
    }
  }

  public startAgent(): void {
    this.identitydoc.socket.startAgent();
  }

  public downloadAgent(): void {
    this.identitydoc.socket.downloadAgent();
  }
}
