import { ConnectorMessageType } from './connector';
import { WebSocketActionsType } from './websocket-action';
export var DocumentType;
(function (DocumentType) {
    DocumentType["CIE"] = "0";
    DocumentType["PASS"] = "1";
})(DocumentType || (DocumentType = {}));
export function isSubscribePacket(packet) {
    return packet?.action === WebSocketActionsType.SUBSCRIBE;
}
export function isSubscribeResponsePacket(packet) {
    return packet?.action === WebSocketActionsType.SUBSCRIBE_RESPONSE;
}
export function isCieDataRequestPacket(packet) {
    return packet?.action === WebSocketActionsType.CIE_DATA_REQUEST;
}
export function isCieDataResponsePacket(packet) {
    return packet?.action === WebSocketActionsType.CIE_DATA_RESPONSE;
}
export function isChannelRequestPacket(packet) {
    return packet?.action === WebSocketActionsType.CHANNEL_REQUEST;
}
export function isChannelResponsePacket(packet) {
    return packet?.action === WebSocketActionsType.CHANNEL_RESPONSE;
}
export function isConnectorMessagePacket(packet) {
    return packet?.action === WebSocketActionsType.CONNECTOR_MESSAGE;
}
export function isConnectorClientConnectedMessagePacket(packet) {
    return packet?.action === WebSocketActionsType.CONNECTOR_MESSAGE && (packet?.payload).message === ConnectorMessageType.CLIENT_CONNECTED;
}
export function isConnectorResponsePacket(packet) {
    return packet?.action === WebSocketActionsType.CONNECTOR_RESPONSE;
}
export function isConnectorErrorPacket(packet) {
    return packet?.action === WebSocketActionsType.CONNECTOR_ERROR || (packet?.payload).message?.includes('ERROR');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2Vic29ja2V0LW1lc3NhZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3dlYnNvY2tldC1tZXNzYWdlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxvQkFBb0IsRUFBRSxNQUFNLGFBQWEsQ0FBQztBQUNuRCxPQUFPLEVBQUUsb0JBQW9CLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUcxRCxNQUFNLENBQU4sSUFBWSxZQUdYO0FBSEQsV0FBWSxZQUFZO0lBQ3RCLHlCQUFPLENBQUE7SUFDUCwwQkFBUSxDQUFBO0FBQ1YsQ0FBQyxFQUhXLFlBQVksS0FBWixZQUFZLFFBR3ZCO0FBK0VELE1BQU0sVUFBVSxpQkFBaUIsQ0FBQyxNQUFrQztJQUNsRSxPQUFPLE1BQU0sRUFBRSxNQUFNLEtBQUssb0JBQW9CLENBQUMsU0FBUyxDQUFDO0FBQzNELENBQUM7QUFFRCxNQUFNLFVBQVUseUJBQXlCLENBQUMsTUFBa0M7SUFDMUUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGtCQUFrQixDQUFDO0FBQ3BFLENBQUM7QUFFRCxNQUFNLFVBQVUsc0JBQXNCLENBQUMsTUFBa0M7SUFDdkUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGdCQUFnQixDQUFDO0FBQ2xFLENBQUM7QUFFRCxNQUFNLFVBQVUsdUJBQXVCLENBQUMsTUFBa0M7SUFDeEUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGlCQUFpQixDQUFDO0FBQ25FLENBQUM7QUFFRCxNQUFNLFVBQVUsc0JBQXNCLENBQUMsTUFBa0M7SUFDdkUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGVBQWUsQ0FBQztBQUNqRSxDQUFDO0FBRUQsTUFBTSxVQUFVLHVCQUF1QixDQUFDLE1BQWtDO0lBQ3hFLE9BQU8sTUFBTSxFQUFFLE1BQU0sS0FBSyxvQkFBb0IsQ0FBQyxnQkFBZ0IsQ0FBQztBQUNsRSxDQUFDO0FBRUQsTUFBTSxVQUFVLHdCQUF3QixDQUFDLE1BQWtDO0lBQ3pFLE9BQU8sTUFBTSxFQUFFLE1BQU0sS0FBSyxvQkFBb0IsQ0FBQyxpQkFBaUIsQ0FBQztBQUNuRSxDQUFDO0FBRUQsTUFBTSxVQUFVLHVDQUF1QyxDQUFDLE1BQWtDO0lBQ3hGLE9BQU8sTUFBTSxFQUFFLE1BQU0sS0FBSyxvQkFBb0IsQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLE1BQU0sRUFBRSxPQUE0QixDQUFBLENBQUMsT0FBTyxLQUFLLG9CQUFvQixDQUFDLGdCQUFnQixDQUFDO0FBQzlKLENBQUM7QUFFRCxNQUFNLFVBQVUseUJBQXlCLENBQUMsTUFBa0M7SUFDMUUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGtCQUFrQixDQUFDO0FBQ3BFLENBQUM7QUFFRCxNQUFNLFVBQVUsc0JBQXNCLENBQUMsTUFBa0M7SUFDdkUsT0FBTyxNQUFNLEVBQUUsTUFBTSxLQUFLLG9CQUFvQixDQUFDLGVBQWUsSUFBSSxDQUFDLE1BQU0sRUFBRSxPQUE0QixDQUFBLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQztBQUNySSxDQUFDIn0=