import { ConnectorMessageType } from './connector';
import { WebSocketActionsType } from './websocket-action';
export declare enum DocumentType {
    CIE = "0",
    PASS = "1"
}
export interface SodHash {
    dataGroup: string;
    hash: string;
}
export interface CieData {
    photo: string;
    firstName: string;
    lastName: string;
    dateOfBirth: string;
    sex: string;
    personalNumber: string;
    citizenship: string;
    stateOfBirth: string;
    cityOfBirth: string;
    state: string;
    city: string;
    address: string;
    documentNumber: string;
    issuingAuthority: string;
    dateOfExpiry: string;
    dateOfIssue: string;
    documentType: DocumentType;
    issuingState: string;
    requestId?: string;
    sod?: string;
    hashes?: SodHash;
    imageFront?: string;
    imageRear?: string;
    email?: string;
    card_found?: boolean;
    mrz?: string;
    other_people?: string;
}
export interface CanCode {
    canCode: string;
}
export interface ChannelResponse {
    pub: string;
    sub: string;
}
export interface ConnectorMessage {
    message: ConnectorMessageType;
    data: any;
}
export interface ConnectorError {
    error: string;
}
export interface SubscribeResponse {
    requestId: string;
    connectionId?: string;
}
export interface IdentitydocWebSocketPacket<Action extends WebSocketActionsType = WebSocketActionsType> {
    action: Action;
    payload?: IdentitydocWebSocketPayload[Action];
    headers?: any;
}
declare type IdentitydocWebSocketPayload = {
    "subscribe": SubscribeResponse;
    "subscribe-response": SubscribeResponse;
    "cie-data-request": CieData;
    "cie-data-response": CieData;
    "channel-request": CanCode;
    "channel-response": ChannelResponse;
    "connector-message": ConnectorMessage;
    "connector-response": boolean;
    "connector-request": any;
    "connector-error": ConnectorError;
};
export declare function isSubscribePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"subscribe">;
export declare function isSubscribeResponsePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"subscribe-response">;
export declare function isCieDataRequestPacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"cie-data-request">;
export declare function isCieDataResponsePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"cie-data-response">;
export declare function isChannelRequestPacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"channel-request">;
export declare function isChannelResponsePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"channel-response">;
export declare function isConnectorMessagePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"connector-message">;
export declare function isConnectorClientConnectedMessagePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"connector-message">;
export declare function isConnectorResponsePacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"connector-response">;
export declare function isConnectorErrorPacket(packet: IdentitydocWebSocketPacket): packet is IdentitydocWebSocketPacket<"connector-error">;
export {};
