import { describe, it } from 'mocha';
import { Identitydoc } from './identitydoc';
// const expect = chai.expect;
describe('Connector SDK Library', () => {
    it('should receive socket messages correctly', (done) => {
        console.log('Test started');
        let allowedMessages = 2;
        const identityDoc = new Identitydoc();
        const params = {
            auth: {
                credentials: {
                    apiKey: 'sandbox-notartel-22e6c405da07caak'
                }
            },
            connectionUrl: 'wss://sand.api.sandbox.signingtoday.com/notaio-id/api/v1/websocket/connect',
            agentDomain: 'st-api.sandbox.signingtoday.com'
        };
        identityDoc.init(params).then(() => {
            identityDoc.socket.start().then(() => {
                identityDoc.socket.subscribe(() => {
                    if (--allowedMessages == 0) {
                        done();
                    }
                });
            });
        });
        console.log('Test ended.');
    }).timeout(10000);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWRlbnRpdHlkb2MudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9saWIvaWRlbnRpdHlkb2MudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsUUFBUSxFQUFFLEVBQUUsRUFBRSxNQUFNLE9BQU8sQ0FBQztBQUVyQyxPQUFPLEVBQUUsV0FBVyxFQUE2QixNQUFNLGVBQWUsQ0FBQztBQUV2RSw4QkFBOEI7QUFDOUIsUUFBUSxDQUFDLHVCQUF1QixFQUFFLEdBQUcsRUFBRTtJQUVyQyxFQUFFLENBQUMsMENBQTBDLEVBQUUsQ0FBQyxJQUFJLEVBQUUsRUFBRTtRQUN0RCxPQUFPLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQzVCLElBQUksZUFBZSxHQUFHLENBQUMsQ0FBQztRQUN4QixNQUFNLFdBQVcsR0FBRyxJQUFJLFdBQVcsRUFBRSxDQUFDO1FBQ3RDLE1BQU0sTUFBTSxHQUE4QjtZQUN4QyxJQUFJLEVBQUU7Z0JBQ0osV0FBVyxFQUFFO29CQUNYLE1BQU0sRUFBRSxtQ0FBbUM7aUJBQzVDO2FBQ0Y7WUFDRCxhQUFhLEVBQUUsNEVBQTRFO1lBQzNGLFdBQVcsRUFBRSxpQ0FBaUM7U0FDL0MsQ0FBQztRQUNGLFdBQVcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRTtZQUNqQyxXQUFXLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUU7Z0JBQ25DLFdBQVcsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRTtvQkFDaEMsSUFBSSxFQUFFLGVBQWUsSUFBSSxDQUFDLEVBQUU7d0JBQzFCLElBQUksRUFBRSxDQUFDO3FCQUNSO2dCQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDN0IsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3BCLENBQUMsQ0FBQyxDQUFDIn0=