"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConnectorErrorPacket = exports.isConnectorResponsePacket = exports.isConnectorClientConnectedMessagePacket = exports.isConnectorMessagePacket = exports.isChannelResponsePacket = exports.isChannelRequestPacket = exports.isCieDataResponsePacket = exports.isCieDataRequestPacket = exports.isSubscribeResponsePacket = exports.isSubscribePacket = exports.DocumentType = void 0;
const connector_1 = require("./connector");
const websocket_action_1 = require("./websocket-action");
var DocumentType;
(function (DocumentType) {
    DocumentType["CIE"] = "0";
    DocumentType["PASS"] = "1";
})(DocumentType = exports.DocumentType || (exports.DocumentType = {}));
function isSubscribePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.SUBSCRIBE;
}
exports.isSubscribePacket = isSubscribePacket;
function isSubscribeResponsePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.SUBSCRIBE_RESPONSE;
}
exports.isSubscribeResponsePacket = isSubscribeResponsePacket;
function isCieDataRequestPacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CIE_DATA_REQUEST;
}
exports.isCieDataRequestPacket = isCieDataRequestPacket;
function isCieDataResponsePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CIE_DATA_RESPONSE;
}
exports.isCieDataResponsePacket = isCieDataResponsePacket;
function isChannelRequestPacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CHANNEL_REQUEST;
}
exports.isChannelRequestPacket = isChannelRequestPacket;
function isChannelResponsePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CHANNEL_RESPONSE;
}
exports.isChannelResponsePacket = isChannelResponsePacket;
function isConnectorMessagePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CONNECTOR_MESSAGE;
}
exports.isConnectorMessagePacket = isConnectorMessagePacket;
function isConnectorClientConnectedMessagePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CONNECTOR_MESSAGE && (packet === null || packet === void 0 ? void 0 : packet.payload).message === connector_1.ConnectorMessageType.CLIENT_CONNECTED;
}
exports.isConnectorClientConnectedMessagePacket = isConnectorClientConnectedMessagePacket;
function isConnectorResponsePacket(packet) {
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CONNECTOR_RESPONSE;
}
exports.isConnectorResponsePacket = isConnectorResponsePacket;
function isConnectorErrorPacket(packet) {
    var _a;
    return (packet === null || packet === void 0 ? void 0 : packet.action) === websocket_action_1.WebSocketActionsType.CONNECTOR_ERROR || ((_a = (packet === null || packet === void 0 ? void 0 : packet.payload).message) === null || _a === void 0 ? void 0 : _a.includes('ERROR'));
}
exports.isConnectorErrorPacket = isConnectorErrorPacket;
//# sourceMappingURL=data:application/json;base64,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