"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const identitydoc_1 = require("./identitydoc");
// const expect = chai.expect;
(0, mocha_1.describe)('Connector SDK Library', () => {
    (0, mocha_1.it)('should receive socket messages correctly', (done) => {
        console.log('Test started');
        let allowedMessages = 2;
        const identityDoc = new identitydoc_1.Identitydoc();
        const params = {
            auth: {
                credentials: {
                    apiKey: 'sandbox-notartel-22e6c405da07caak'
                }
            },
            connectionUrl: 'wss://sand.api.sandbox.signingtoday.com/notaio-id/api/v1/websocket/connect',
            agentDomain: 'st-api.sandbox.signingtoday.com'
        };
        identityDoc.init(params).then(() => {
            identityDoc.socket.start().then(() => {
                identityDoc.socket.subscribe(() => {
                    if (--allowedMessages == 0) {
                        done();
                    }
                });
            });
        });
        console.log('Test ended.');
    }).timeout(10000);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWRlbnRpdHlkb2MudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9saWIvaWRlbnRpdHlkb2MudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGlDQUFxQztBQUVyQywrQ0FBdUU7QUFFdkUsOEJBQThCO0FBQzlCLElBQUEsZ0JBQVEsRUFBQyx1QkFBdUIsRUFBRSxHQUFHLEVBQUU7SUFFckMsSUFBQSxVQUFFLEVBQUMsMENBQTBDLEVBQUUsQ0FBQyxJQUFJLEVBQUUsRUFBRTtRQUN0RCxPQUFPLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQzVCLElBQUksZUFBZSxHQUFHLENBQUMsQ0FBQztRQUN4QixNQUFNLFdBQVcsR0FBRyxJQUFJLHlCQUFXLEVBQUUsQ0FBQztRQUN0QyxNQUFNLE1BQU0sR0FBOEI7WUFDeEMsSUFBSSxFQUFFO2dCQUNKLFdBQVcsRUFBRTtvQkFDWCxNQUFNLEVBQUUsbUNBQW1DO2lCQUM1QzthQUNGO1lBQ0QsYUFBYSxFQUFFLDRFQUE0RTtZQUMzRixXQUFXLEVBQUUsaUNBQWlDO1NBQy9DLENBQUM7UUFDRixXQUFXLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUU7WUFDakMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFO2dCQUNuQyxXQUFXLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUU7b0JBQ2hDLElBQUksRUFBRSxlQUFlLElBQUksQ0FBQyxFQUFFO3dCQUMxQixJQUFJLEVBQUUsQ0FBQztxQkFDUjtnQkFDSCxDQUFDLENBQUMsQ0FBQztZQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQzdCLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUNwQixDQUFDLENBQUMsQ0FBQyJ9