"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClientDownloadUrl = exports.MAC_CLIENT_URL = exports.WIN_CLIENT_URL = void 0;
exports.WIN_CLIENT_URL = "https://assets.bit4id.click/download?package=st-agent&version=latest&platform=windows";
exports.MAC_CLIENT_URL = "https://assets.bit4id.click/download?package=st-agent&version=latest&platform=macos";
function getClientDownloadUrl() {
    const platform = navigator.platform;
    if (platform.startsWith("Win")) {
        return exports.WIN_CLIENT_URL;
    }
    if (platform.startsWith("Mac")) {
        return exports.MAC_CLIENT_URL;
    }
    return null;
}
exports.getClientDownloadUrl = getClientDownloadUrl;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWdlbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL2FnZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFhLFFBQUEsY0FBYyxHQUFHLHVGQUF1RixDQUFDO0FBQ3pHLFFBQUEsY0FBYyxHQUFHLHFGQUFxRixDQUFDO0FBRXBILFNBQWdCLG9CQUFvQjtJQUNsQyxNQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsUUFBUSxDQUFDO0lBQ3BDLElBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsRUFBRTtRQUM3QixPQUFPLHNCQUFjLENBQUM7S0FDdkI7SUFFRCxJQUFJLFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLEVBQUU7UUFDOUIsT0FBTyxzQkFBYyxDQUFDO0tBQ3ZCO0lBRUQsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBWEQsb0RBV0MifQ==